#include <stdlib.h>
#include <stdio.h>
#include <stddef.h>
#include <math.h>

#include <SDL2/SDL.h>
#include <GL/gl.h>

#include "shaders.h"

SDL_Window* window = NULL;
char* title = "Intro";
int start = 0;
SDL_GLContext glcontext;
SDL_Event event;
GLuint program = 0;
int time = 0;
const int clipLen = 60 * 1000;

#include "syna.h"

GLfloat verts[] = {
	-1.0f, -1.0f, 0.0f, -1.0f, -1.0f,
	1.0f, -1.0f, 0.0f, 1.0f, -1.0f,
	-1.0f, 1.0f, 0.0f, -1.0f, 1.0f,
	1.0f, 1.0f, 0.0f, 1.0f, 1.0f
};

GLuint idx[] = {
	0, 1, 2,
	2, 1, 3
};

SDL_AudioSpec audio;

void createShader(GLint shaderType, const char* shadercode)
{
	GLint success;
	GLchar info[1024];
	GLuint shader;
	shader = glCreateShader(shaderType);
	glShaderSource(shader, 1, &shadercode, 0);
	glCompileShader(shader);
	glAttachShader(program, shader);

	glGetShaderiv(shader, GL_COMPILE_STATUS, &success);
	if (!success) {
		glGetShaderInfoLog(shader, 1024, NULL, info);
	}
}

void initShader()
{
	GLint success;
	GLchar info[1024];
	
	program = glCreateProgram();
	createShader(GL_VERTEX_SHADER, vshader);

	createShader(GL_FRAGMENT_SHADER, fshader);

	glLinkProgram(program);

	glGetProgramiv(program, GL_LINK_STATUS, &success);
	if (!success) {
		glGetProgramInfoLog(program, 1024, NULL, info);
		printf("ERROR SHADER compiling failed\n%s\n",info);
	}

	glUseProgram(program);
}

void setBuffers()
{
	GLuint VAO, VBO, IBO;
	glGenVertexArrays(1, &VAO);
	glBindVertexArray(VAO);

	glGenBuffers(1, &VBO);
	glBindBuffer(GL_ARRAY_BUFFER, VBO);
	glBufferData(GL_ARRAY_BUFFER, sizeof(verts), verts, GL_STATIC_DRAW);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 5 * sizeof(GLfloat), (GLvoid*)0);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(1, 2, GL_FLOAT, GL_FALSE, 5 * sizeof(GLfloat), (GLvoid*) (3 * sizeof(GLfloat)));
	glEnableVertexAttribArray(1);

	glGenBuffers(1, &IBO);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, IBO);
	glBufferData(GL_ELEMENT_ARRAY_BUFFER, sizeof(idx), idx, GL_STATIC_DRAW);
}

void update()
{
	glUniform1i(1, time);
}

void render()
{
	glClearColor(0,0,0,1);
	glClear(GL_COLOR_BUFFER_BIT);
	glDrawElements(GL_TRIANGLES, 6, GL_UNSIGNED_INT, 0);
}

int main()
{
	SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_TIMER);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 4);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 3);
	SDL_GL_SetAttribute(SDL_GL_CONTEXT_PROFILE_MASK, SDL_GL_CONTEXT_PROFILE_CORE);
	window = SDL_CreateWindow(title, SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, 1920, 1080, SDL_WINDOW_OPENGL);
	glcontext = SDL_GL_CreateContext(window);
	//SDL_SetWindowFullscreen(window, SDL_WINDOW_FULLSCREEN);
	//SDL_SetWindowFullscreen(window, SDL_WINDOW_FULLSCREEN_DESKTOP);
	SDL_SetWindowFullscreen(window, 0);

	initShader();
	setBuffers();

	SDL_memset(&audio, 0, sizeof(audio));
	audio.freq = 44100;
	audio.format = AUDIO_U8;
	audio.channels = 2;
	audio.samples = 1024;
	audio.callback = syna;

	SDL_OpenAudio(&audio, NULL);

	SDL_ShowCursor(0);
	SDL_PauseAudio(0);
	start = SDL_GetTicks();
	while(1)
	{
		time = SDL_GetTicks() - start;
		if(time > clipLen)
			break;
		update();
		render();
		SDL_GL_SwapWindow(window);
		while(SDL_PollEvent(&event))
		{
			if(event.type == SDL_KEYDOWN && event.key.keysym.sym == SDLK_ESCAPE)
			{
				printf("Closing!\n");
				start = -clipLen;
			}
		}
	}

	SDL_DestroyWindow(window);
	SDL_GL_DeleteContext(glcontext); 
	SDL_Quit();
	return 0;
}
